// This scilab code is to calculate basic image statistics
//such as sum, average, standard deviation, min and max

//The scilab environment for this is : Scilab 5.5.2

//Toolbox used: SIVP 0.5.3.2

//OS used :Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

clc //to clear command window.
clear all //to kill previously defined variables.
xdel(winsid())//to close all currently open figure(s).

//This code uses camaraman.tif file for processing

img = imread('cameraman.tif'); // Reads the cameraman image
imshow(img); // Show original image.
if(size(img,3)>1) then 
    Gray_img= rgb2gray(img); //Converts color image to grayscale
else 
    Gray_img=img;           // if image is 2D image
end
imshow(Gray_img);           // Show gray scale image.
imgsum=sum(Gray_img);       // Calculates sum of image pixels
imgmean=mean2(Gray_img);    // Calculates mean / average of image pixels
imgstd=std2(Gray_img);      // Calculates standard deviation of image
imgmin=min(Gray_img);       // Calculates minimum of image pixels
imgmax=max(Gray_img);       // Calculates maximum of image pixels.
disp("Size of Image ="); 
disp(size(Gray_img));       // Displays size of image
disp("Sum = ");
disp(imgsum);               // Displays Sum of image pixels
disp("Mean = ");
disp(imgmean);              // DIsplays mean / average of image pixels
disp("Standard Deviation = ");
disp(imgstd);               // Displays standard deviation of image pixels
disp("Minimum of Image = ");
disp(imgmin);               // Displays minimum of image
disp("Maximum of Image =");
disp(imgmax);               // Displays maximum of image

/////////// OUTPUT ///////////
//
//Size of Image =   
// 
//    256.    256.  
// 
// Sum =    
// 
//  120  
// 
// Mean =    
// 
//    118.72449  
// 
// Standard Deviation =    
// 
//    62.341715  
// 
// Minimum of Image =    
// 
//  7  
// 
// Maximum of Image =   
// 
//  253 
